<?php
/*------------------------------------------------
 * Loader Torgsoft trs file for Horoshop  20240818
 * Copyright © FinBoss 2024
 * finboss.ua@gmail.com
 *
 * перегляд категорій
 *
 * License: Commercial open source software (COSS)
 *------------------------------------------------
 */

error_reporting (E_ALL);

header('Content-Type: text/html; charset=UTF-8');

// контроль доступа по IP
$a_allow = false;
$a_ips = '';
if (is_file('.allowed_ip')){
	$a_ips = file('.allowed_ip');
}elseif (is_file('../.allowed_ip')){
	$a_ips = file('../.allowed_ip');
}

if (is_array($a_ips)){
	foreach ($a_ips as $a_ip){
		$a_ip = trim($a_ip);
		if (strpos($a_ip, '*') !== false){
			
			// process 127.0.*.*
			
			$remote = explode('.', $_SERVER['REMOTE_ADDR']);
			$a = explode('.', $a_ip);
			
			$true_count = 0;
			for ($i=0;$i<4;$i++){
				switch ($i){
					case 0:
					case 1:
						if ($remote[$i] != $a[$i]){
							break 2;
						}else{
							$true_count++;
						}
						break;
					case 2:
					case 3:
						if ($a[$i] == '*'){
							// пропускаем
							$true_count++;
						}else{
							if ($remote[$i] != $a[$i]){
								break 2;
							}else{
								$true_count++;
							}
						}
						
				}
			}
			if ($true_count == 4){
				$a_allow = true;
				break;
			}
			
		}else{
			if ($_SERVER['REMOTE_ADDR'] == trim($a_ip)){
				$a_allow = true;
				break;
			}
		}
	}
	
}
if ($a_allow === false){
	die('доступ для IP '.$_SERVER['REMOTE_ADDR'].' заблоковано');
}

@set_time_limit(0);

// имя файла
$d = dir(".");
$config_file = '';
while (false !== ($entry = $d->read())) {
	if ($entry != ".")
		if ($entry != "..")
			if (strpos($entry, ".cfg.") !== false){
				$config_file = $entry;
				break;
		}
}
$d->close();

if ($config_file != ''){		// конфиг-файл))
	require_once ($config_file);
}else{
	echo ("Помилка: Не знайдено конфігураційний файл");
	exit;
}

// получение token
$url = $h_site_ssl_select.'://'.$h_domain.'/api/auth/?login='.$h_login.'&password='.$h_password;

$string = curl_get_contents($url);

$data = json_decode($string, true);

if (isset($data['status']) AND $data['status'] == 'OK'){
	$token = $data['response']['token'];
}else{
	die ("Помилка: Не вдалося авторизуватись на сайті '$h_site_ssl_select://$h_domain'"." <br/>Відповідь сервера:$string");
}

	if (!isset($_POST['article'])){
	
		echo ("Отримання інформації про категорії з сайту".date(" Y-m-d H:i:s"));
		
		$url = $h_site_ssl_select.'://'.$h_domain.'/api/pages/export/?token='.$token;
		
		$string = curl_get_contents($url);
		
		$data = json_decode($string, true);
		
		if (isset($data['status']) AND $data['status'] == 'OK'){
			$result = $data['response']['pages'];
		}else{
			echo("Помилка: Не вдалося отримати дані за посиланням 'api/pages/export' Відповіль сервера: $string");
			die;
		}
		
		// 	используется $main_language_code
		
		$categories_b = $categories_parent = $categories_path = array();
		foreach ($result as $result1){
			if ($result1['parent'] == 0){
				$categories_b[$result1['id']] = trim($result1['title'][$main_language_code]);
				get_subcat($result, trim($result1['title'][$main_language_code]), $result1['id']);
			}
		}
		
		echo('<br/>'."Усього категорій на сайті ".count($categories_b));
		asort($categories_b);
		foreach ($categories_b as $key => $value){
			echo('<br/><a href="show_products.php?category_id='.$key.'">'.$value."</a> ($key)");
		}
			
		echo '<br/>';
		
		echo '<h1>Для перегляду відомостей про характеристики товару клацніть назву категорії</h1>';
		
		if (!isset($_GET['category_id'])){
			die;
		}else{
		
			foreach ($categories_b as $key => $value){
					
				if ($_GET['category_id'] == $key){
					
					echo "<h2>$value</h2>";
				
					$url = $h_site_ssl_select.'://'.$h_domain.'/api/catalog/export/';
					
					$offset = 0;
					$limit = 1;
					
					$param = array(
							'token' => $token,
							'offset' => $offset,
							'limit' => $limit,
							'expr' => array(
									'parent' => array(
											'id' => $key
									)
							),
					);
					
					$string = curl_get_contents($url, $param);
					
					$data = json_decode($string, true);
					
					if (isset($data['status']) AND $data['status'] == 'OK'){
						
						$result = $data['response']['products'];
						if (count($result) == 0){
							die ('<br/>'."Помилка: в обраній категорії немає жодного товару - додайте через адмін панель сайту хоча б один товар до обраної категорії");
							die;
						}
						echo "<br/><hr/>";
		// 				echo "<br/>Категория:".$value;
						echo '<pre>';
						print_r($result[0]);
						echo '</pre>';
						
						
					}else{
						die ("Помилка: Не вдалося отримати дані за посиланням 'api/catalog/export'");
						die;
					}
					
					
					die;
				}
			}
		}
		
	}else{
	
		$article = $_POST['article'];
		
		$url = $h_site_ssl_select.'://'.$h_domain.'/api/catalog/export/';
		//?token='.$token.'&offset=0&limit=1&expr[\'article\'][]='.$article.'&includedParams[]=mpn';
		
		$send_data = array(
				'token' 		=> $token,
				'expr' 			=> array(
						'article' => $article
				)
		);
		
		$string = curl_post_json($url, $send_data);
		
		$data = json_decode($string, true);
		
		if (isset($data['status']) AND $data['status'] == 'OK'){
			$result_p = $data['response']['products'];
		}else{
			echo("Помилка: Неможливо отримати відомості про товар за посиланням '$url'".date(" Y-m-d H:i:s"));
			echo("<br/>Відповідь сервера: ".$string);
			die;
		}
		
		echo "<br/>Артикул моделі:".$article;
		
		echo '<pre>';
		print_r($result_p[0]);
		echo '</pre>';
		
	}
	


///////////////////////////////////////////////////////////////////////////////////////////////

function curl_get_contents($url, array $get = array(), array $options = array()){
	
	global $curl_result, $timestamp;
	
	if (strpos($url, 'http') === false){
		$url = 'https://'.$url;
	}
	
	$defaults = array(
			CURLOPT_URL => $url. (strpos($url, '?') === FALSE ? '?' : ''). http_build_query($get),
			CURLOPT_HEADER => 0,
			CURLOPT_RETURNTRANSFER => TRUE,
			CURLOPT_FOLLOWLOCATION => 1,
			CURLOPT_TIMEOUT => 60,
			CURLOPT_SSL_VERIFYPEER => false
	);
	
	$ch = curl_init();
	curl_setopt_array($ch, ($options + $defaults));
	curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US; rv:1.9.1.2) Gecko/20090729 Firefox/3.5.2 GTB5');
	if(!$result = curl_exec($ch)) {
		trigger_error(curl_error($ch));
		$result = 'Error: '.curl_error($ch);
	}else{
		//echo 'OK';
	}
	curl_close($ch);
	
	return $result;
}

function get_subcat($result, $name, $id_parent){
	
	global $categories_b, $categories_parent, $categories_path, $main_language_code;
	
	foreach ($result as $result1){
		if ($result1['parent'] == $id_parent){
			$categories_b[$result1['id']] = $name.'>'.trim($result1['title'][$main_language_code]);
			get_subcat($result, $name.'>'.trim($result1['title'][$main_language_code]), $result1['id']);
		}
	}
	
}

function curl_post_json($url, array $get = NULL, array $options = array())
{
	$defaults = array(
			CURLOPT_URL => $url,
			CURLOPT_POST => true,
			CURLOPT_RETURNTRANSFER => TRUE,
			CURLOPT_FOLLOWLOCATION => 1,
			CURLOPT_TIMEOUT => 60,
			CURLOPT_SSL_VERIFYPEER => false,
	);
	
	$data_string = json_encode($get);
	
	$ch = curl_init();
	curl_setopt_array($ch, ($options + $defaults));
	// 	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
	curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
	curl_setopt($ch, CURLINFO_HEADER_OUT, true);
	// 	curl_setopt($ch, CURLOPT_PORT, 8999);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			'Content-Type: application/json',
			'Content-Length: ' . strlen($data_string))
			);
	
	// 	curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US; rv:1.9.1.2) Gecko/20090729 Firefox/3.5.2 GTB5');
	if(!$result = curl_exec($ch)) {
		trigger_error(curl_error($ch));
		$result = 'Error: '.curl_error($ch);
	}else{
		//echo 'авторизация - OK <br/>';
	}
	curl_close($ch);
	
	return $result;
}